#include "FileTestCase.h"
#include <fstream>
#include <algorithm>
#include <iterator>
#include <string>

FileTestCase::FileTestCase( const std::string& filename )
{
	std::ifstream in( filename );

	std::getline( in,casename );
	casename = "File Test: " + casename;

	in >> expected;
	std::copy(
		std::istream_iterator<unsigned int>( in ),std::istream_iterator<unsigned int>{},
		std::back_inserter( input )
	);
	input.shrink_to_fit();
}

bool FileTestCase::Run( SolutionSignature f ) const
{
	return f( input ) == expected;
}

FileTestCase::operator const std::string&() const
{
	return casename;
}
