#include <vector>
#include <iostream>
#include <filesystem>
#include <conio.h>
#include "TestRunner.h"
#include "FileTestCase.h"
#include "Parameters.h"

int main()
{
	using namespace std::string_literals;
	namespace fs = std::filesystem;

	std::vector<std::unique_ptr<TestCase>> testCases;
	for( const auto& entry : fs::directory_iterator( "TestData"s ) )
	{
		testCases.push_back( std::make_unique<FileTestCase>( entry.path().string() ) );
	}

	TestRunner runner{ std::move( testCases ) };
	runner.Run( Solution::Solve );
	runner.OuputResults( std::cout );

	while( !_kbhit() );
	return 0;
}
