#include "TestRunner.h"
#include <iomanip>
#include <string>

TestRunner::TestRunner( std::vector<std::unique_ptr<TestCase>> tests )
	:
	tests( std::move( tests ) )
{}

void TestRunner::Run( SolutionSignature f )
{
	results.clear();
	for( const auto& test : tests )
	{
		ft.Mark();
		const auto r = test->Run( f );
		results.push_back( { r,ft.Mark(),(std::string)*test } );
	}
}

void TestRunner::OuputResults( std::ostream& out ) const
{
	for( const auto& r : results )
	{
		out << (r.passed ? "PASS" : "FAIL");
		out << " (" << std::fixed << std::setprecision( 2 ) << r.time  * 1000.0f << "ms) ";
		out << r.testname << std::endl;
	}
}
