#pragma once
#include "Parameters.h"
#include <chrono>

class TestCase
{
public:
	struct Result
	{
		bool passed;
		Output actual;
		Output expected;
		float runtime;
	};
public:
	TestCase( std::chrono::duration<int,std::milli> timeoutMilli,std::string casename,bool advanced )
		:
		timeoutMilli( timeoutMilli ),
		casename( std::move( casename ) ),
		advanced( advanced )
	{}
	Result Run( class FrameTimer& ft ) const;
	operator const std::string&() const
	{
		return casename;
	}
	int GetTimeoutMilli() const
	{
		return timeoutMilli.count();
	}
	bool IsAdvanced() const
	{
		return advanced;
	}
	TestCase& SpinUp()
	{
		SpinUp_();
		spunUp = true;
		return *this;
	}
	bool IsSpunUp() const
	{
		return spunUp;
	}
	const Output& GetExpected() const
	{
		return const_cast<TestCase*>(this)->GetExpected_();
	}
	const Input& GetInput() const
	{
		return const_cast<TestCase*>(this)->GetInput_();
	}
protected:
	virtual Output& GetExpected_() = 0;
	virtual Input& GetInput_() = 0;
	virtual void SpinUp_() = 0;
private:
	bool spunUp = false;
	std::chrono::duration<int,std::milli> timeoutMilli;
	std::string casename;
	bool advanced;
};