#include "TestRunner.h"
#include <iomanip>
#include <string>

TestRunner::TestRunner( std::vector<std::unique_ptr<TestCase>> tests )
	:
	tests( std::move( tests ) )
{}

void TestRunner::Run()
{
	results.clear();
	for( const auto& test : tests )
	{
		const auto r = test->SpinUp().Run( ft );
		results.push_back( { r,(std::string)*test } );
	}
}

void TestRunner::OuputResults( std::ostream& out ) const
{
	for( const auto& r : results )
	{
		out << (r.tcr.passed ? "PASS" : "FAIL");
		out << " (" << std::fixed << std::setprecision( 2 ) << r.tcr.runtime * 1000.0f << "ms) ";
		out << r.testname << std::endl;
		if( !r.tcr.passed )
		{
			out << "   Expected: " << r.tcr.expected << " | Actual: " << r.tcr.actual << std::endl;
		}
	}
}
