#include "FileTestCase.h"
#include <fstream>
#include <algorithm>
#include <iterator>
#include <string>
#include <sstream>
#include <iostream>

using namespace std::string_literals;

FileTestCase::FileTestCase( const std::string& filename,bool advanced,std::chrono::duration<int,std::milli> timeoutMilli )
	:
	TestCaseEmbeds( timeoutMilli,ReadCaseName( filename ),advanced ),
	filename( filename )
{
}

void FileTestCase::SpinUp_()
{
	std::ifstream in( filename );

	if( in.fail() )
	{
		throw std::runtime_error( "Failed to open test case file" );
	}

	// ignore name line
	std::string s;
	std::getline( in,s );

	in >> expected;
	in >> input.fieldSize;
	// eat an endl
	std::getline( in,s );

	while( std::getline( in,s ) )
	{
		std::istringstream iss( s );
		InputCommand c;
		iss >> c.quantity;
		iss >> c.offset;
		iss >> c.count;
		input.commands.push_back( c );
	}

	input.commands.shrink_to_fit();
}

std::string FileTestCase::ReadCaseName( const std::string& filename )
{
	std::ifstream in( filename );
	if( in.fail() )
	{
		throw std::runtime_error( "Failed to open test case file" );
	}
	std::string caseName;
	std::getline( in,caseName );
	return "File Test: "s + caseName;
}