#pragma once
#include <vector>
#include <ostream>
#include <memory>
#include "Parameters.h"
#include "FrameTimer.h"
#include "TestCase.h"

class TestRunner
{
private:
	struct Result
	{
		TestCase::Result tcr;
		std::string testname;
	};
public:
	TestRunner( std::vector<std::unique_ptr<TestCase>> tests );
	void Run();
	void OuputResults( std::ostream& out ) const;
private:
	FrameTimer ft;
	std::vector<std::unique_ptr<TestCase>> tests;
	std::vector<Result> results;
};