// see Parameters.h for definition of problem Input and Output types
#include "Parameters.h"
// add any extra includes you like here *from the standard library + msvc intrinsics only*

#include <algorithm>
#include <iostream>
#include <execution>
#include <future>

namespace Solution // do not modify this line!
{
	// optionally implement any extra functions
	// or classes you like INSIDE this namespace
	
	template<typename I>
	void AllocateUnits( I begin,I end,size_t units )
	{
		constexpr size_t chunk_size = 1u;
		const auto nChunks = units / chunk_size;
		const auto nGroups = end - begin;
		const auto overflow = nChunks % nGroups;
		const auto groupSize = nChunks / nGroups;
		for( size_t c = 0; begin != end; ++begin,c++ )
		{
			*begin = (groupSize + (c < overflow ? 1 : 0)) * chunk_size;
		}
	}

	// implementing this function is mandatory
	Output Solve( const Input& input )
	{
		if( input.fieldSize > 30 )
		{
			std::vector<std::pair<unsigned int,int>> deltas;
			deltas.reserve( input.commands.size() * 2 );

			for( const auto& c : input.commands )
			{
				deltas.emplace_back( c.offset,c.quantity );
				deltas.emplace_back( c.offset + c.count,-(int)c.quantity );
			}
			std::sort( std::execution::par_unseq,deltas.begin(),deltas.end() );

			long long max = 0;
			long long sum = 0;
			for( const auto& d : deltas )
			{
				sum += d.second;
				max = std::max( max,sum );
			}

			return max;
		}
		else
		{
			size_t jobs[4];
			std::vector<long long> graves[4];
			std::future<void> futures[4];

			const auto DoWork = [&input]( std::vector<long long>& graves,size_t start,size_t end )
			{
				graves.resize( input.fieldSize );
				for( auto i = start; i < end; i++ )
				{
					const auto q = input.commands[i].quantity;
					const auto s = input.commands[i].offset;
					const auto e = s + input.commands[i].count;
					for( auto j = s; j < e; j++ )
					{
						graves[j] += q;
					}
				}
			};

			AllocateUnits( std::begin( jobs ),std::end( jobs ),input.commands.size() );
			std::transform( 
				std::begin( graves ),std::end( graves ),
				std::begin( jobs ),std::begin( futures ),
				[start = 0ull,DoWork]( auto& g,size_t len ) mutable
				{
					const auto s = start;
					return std::async( DoWork,std::ref( g ),s,start += len );
				}
			);
			for( auto& f : futures )
			{
				f.get();
			}

			long long max = 0;
			for( size_t i = 0; i < input.fieldSize; i++ )
			{
				max = std::max( max,graves[0][i] + graves[1][i] + graves[2][i] + graves[3][i] );
			}

			return max;
		}
	}
}
